/**
* \file: Common.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_COMMON_H
#define CARPLAY_COMMON_H

#include <adit_logging.h>
#include <string>

#define CARPLAY_EXPORTED __attribute__((visibility("default")))
#define CARPLAY_HIDDEN __attribute__((visibility("hidden")))

LOG_IMPORT_CONTEXT(dipo)

namespace adit { namespace carplay
{
    /* version values in version.cpp */
    extern std::string const CarPlayCommunicationsPluginVersion;
    extern std::string const CarPlayDevelopedWithiOSVersion;
    extern std::string const CarPlaySourceVersion;
} } /* namespace adit { namespace carplay */


#define DIPO_PROTECT_LOG_BEGIN(deltaSeconds) \
    { \
        static struct timespec dipo_protect_log_last = { 0, 0 }; \
        static uint32_t dipo_protect_log_counter = 0; \
        struct timespec dipo_protect_log_now; \
        clock_gettime(CLOCK_MONOTONIC, &dipo_protect_log_now); \
        dipo_protect_log_counter++; \
        if (dipo_protect_log_now.tv_sec > dipo_protect_log_last.tv_sec + deltaSeconds) \
        {
#define DIPO_PROTECT_LOG_END \
            dipo_protect_log_last = dipo_protect_log_now; \
            dipo_protect_log_counter = 0; \
        } \
    }

/*
 *
 * Measuring Latency in nano seconds
 *
 */

#ifdef ADIT_MEASURE_LATENCY
#   define SECTONANO 1000000000
#   define DIPO_START_TIME_STAMP() \
         struct timespec start;\
         clock_gettime(CLOCK_MONOTONIC, &start) \

#   define DIPO_END_TIME_STAMP() \
         struct timespec end;\
         clock_gettime(CLOCK_MONOTONIC, &end);\
         long long int latency;\
         latency = ((end.tv_sec * SECTONANO) + end.tv_nsec) - ((start.tv_sec * SECTONANO) + start.tv_nsec); \
         fprintf(stderr, "\033[1m\033[31mLATENCY of %s : %lld in ns",__FUNCTION__,latency)
#else
#   define DIPO_START_TIME_STAMP()
#   define DIPO_END_TIME_STAMP()
#endif /* ADIT_MEASURE_LATENCY */

#include <dipo_macros.h>

#include <stdio.h>
#include <adit_typedef.h>
#include "IConfiguration.h"
#include "Factory.h"

#endif /* CARPLAY_COMMON_H */
